#ifndef SEP_UTILS_H
#define SEP_UTILS_H


/**
 * @brief This function gets the message op-code.
 *
 * @param[in] msg_ptr - the SeP input message
 *
 * @return DxUint32_t - message op-code
 */
 DxUint32_t DX_SEP_GetMsgOpCode(DxUint32_t* msg_ptr);

/**
 * @brief This function sets the returned error code and the message length
 *
 * @param[in] msg_ptr - the SeP input message
 * @param[in] rc - the returned error code
 * @param[in] msgParamLen - the message length 
 *
 * @return DxUint32_t - message length 
 */
 DxUint32_t DX_SEP_EndMessage(DxUint32_t* msg_ptr, DxUint32_t rc, DxUint32_t msgParamLen);


#endif /* SEP_UTILS_H */
